
on isSandboxed()
	local homeDir
	tell application id "com.evernote.Evernote"
		set homeDir to (path to home folder) as string
		if homeDir contains ":Containers:com.evernote.Evernote:" then return true
		return false
	end
end

on getNotebooks()
	tell application id "com.evernote.Evernote" to return name of notebooks
end

on getNoteIDs(theNotebookName)
	tell application id "com.evernote.Evernote" to return local id of notes of (notebook named theNotebookName)
end

on getNoteProperties(theNoteID,theNotebookName)
	local theNotebook, theNote, theTitle, theURL, theTags, theTagNames, theCreationDate, theModificationDate
	tell application id "com.evernote.Evernote"
		set theNotebook to (notebook named theNotebookName)
		set theNote to (note 1 of theNotebook whose local id is theNoteID)

		set theTitle to title of theNote
		set theURL to source URL of theNote
		set theCreationDate to (creation date of theNote)
		set theModificationDate to (modification date of theNote)
		set theID to local id of theNote

		set theTags to tags of theNote
		set theTagNames to {}
		repeat with theTag in theTags
			set theTagNames to theTagNames & (name of theTag)
		end repeat
						
		return {|title|:theTitle,|URL|:theURL,|tags|:theTagNames,|creation|:theCreationDate,|modification|:theModificationDate,|UUID|:theID}
	end
end

on getNoteName(theNoteID,theNotebookName)
	local theNotebook, theNote
	tell application id "com.evernote.Evernote"
		set theNotebook to (notebook named theNotebookName)
		set theNote to (note 1 of theNotebook whose local id is theNoteID)
		return title of theNote
	end
end

on getNoteLink(theNoteID,theNotebookName)
	local theNotebook, theNote
	tell application id "com.evernote.Evernote"
		set theNotebook to (notebook named theNotebookName)
		set theNote to (note 1 of theNotebook whose local id is theNoteID)
		return note link of theNote
	end
end

on exportNote(theNoteID,theNotebookName,theTempFolder)
	local theNotebook, theNote, theExportFolder

	tell application id "com.evernote.Evernote"
		set theNotebook to (notebook named theNotebookName)
		set theNote to (note 1 of theNotebook whose local id is theNoteID)
		set theExportFolder to ((theTempFolder as POSIX file) as string) & "Evernote-2-DEVONthink-Export:"
					
		export (theNote as list) to theExportFolder format HTML
		
		return POSIX path of theExportFolder
	end
end

on exportENEX(theRangeStart,theRangeEnd,theNotebookName,theTempFolder)
	local theNotebook, theNotes, theExportFile

	tell application id "com.evernote.Evernote"
		set theNotebook to (notebook named theNotebookName)
		set theNotes to notes of theNotebook
		set theNotes to item theRangeStart thru theRangeEnd of theNotes
		set theExportFile to ((theTempFolder as POSIX file) as string) & "Evernote-2-DEVONthink-Export.enex"
		export theNotes to theExportFile format ENEX
		return POSIX path of theExportFile
	end
end

on getNoteLinks(theNotebookName)
	local theNotebook, theNotes, theNoteLinks

	tell application id "com.evernote.Evernote"
		set theNotebook to (notebook named theNotebookName)
		set theNotes to notes of theNotebook
		set theNoteLinks to {}
		repeat with theNote in theNotes
			try
				set theNoteLinks to theNoteLinks & (note link of theNote)
			on error
				set theNoteLinks to theNoteLinks & ""
			end
		end
		return theNoteLinks
	end
end
