on getItemIDs()
	tell application "Yojimbo" to return id of database items
end

on exportItem(theID,theTempFolder)
	tell application "Yojimbo"
		set theItem to (database item 1 whose id is theID)
		set thePath to ((theTempFolder as POSIX file) as string) & theID
		return export theItem to file thePath
	end
end

on getItemProperties(theID)
	tell application "Yojimbo"
		set theItem to (database item 1 whose id is theID)

		set theTitle to name of theItem
		set theCreationDate to creation date of theItem
		set theModificationDate to modification date of theItem

		set theTags to tags of theItem
		set theTagNames to {}
		repeat with theTag in theTags
			set theTagNames to theTagNames & (name of theTag)
		end repeat

		set theComments to comments of theItem
		set isFlagged to flagged of theItem
		set theLabel to label of theItem

		return {|title|:theTitle,|tags|:theTagNames,|creation|:theCreationDate,|modification|:theModificationDate,|label|:theLabel,|flagged|:isFlagged,|comments|:theComments,|class|:(class of theItem as string)}
	end
end
