on getUserGroupNames()
	tell application "Bookends" to return name of group items of front library window
end getUserGroupNames

on getGroupItems(theGroupName)
	local theGroup
	tell application "Bookends"
		if theGroupName is "All" then
			set theGroup to group all of front library window
		else if theGroupName is "Attachments" then
			set theGroup to group attachments of front library window
		else if theGroupName is "Hits" then
			set theGroup to group hits of front library window
		else if theGroupName is "Selection" then
			return selected publication items of front library window
		else
			set theGroup to group item named theGroupName of front library window
		end if
		return publication items of theGroup
	end tell
end getGroupItems

on getFormattedReferenceAsRTF(theRef, theFormat)
	tell application "Bookends" to return format theRef using theFormat as RTF
end getFormattedReferenceAsRTF

on getProperties(theRef)
	tell application "Bookends" to return {|id|:id, |title|:title, comment:notes, |dateAdded|:date added, |dateModified|:date modified, |rating|:rating, label:label color, author:authors, |keywords|:keywords} of theRef
end getProperties

on getMetadata(theRef)
	tell application "Bookends" to return {|doi|:doi, |pmid|:pmid, |is?n|:isbn, link:url, |language|:language, |date|:publication date string, |editors|:editors, |publisher|:publisher, |journal|:journal, |volume|:volume, page:pages, citation:user1, |abstract|:abstract} of theRef
end getMetadata

on getFormattedReference(theRef, theFormat)
	tell application "Bookends" to return format theRef using theFormat
end getFormattedReference
