
-- Warning: Due to the broken AppleScript of Notes on Catalina don't store account/folder/note references in variables

on getAccounts()
	tell application id "com.apple.Notes" to return id of accounts
end getAccounts

on getAccountFolders(theAccountID)
	local theIDs
	tell application id "com.apple.Notes"
		set theIDs to {}
		repeat with theFolder in folders of (item 1 of (accounts whose id is theAccountID as list))
			-- Filter all subfolders
			if class of (container of theFolder) is account then
				set theContainerID to id of (container of theFolder) as string
				if theContainerID is equal to theAccountID then set theIDs to theIDs & id of theFolder
			end if
		end repeat
		return theIDs
	end tell
end getAccountFolders

on getSubFolders(theFolderID)
	tell application id "com.apple.Notes" to return id of folders of (item 1 of (folders whose id is theFolderID as list))
end getSubFolders

on getNameAndNotes(theFolderID)
	local theFolder
	tell application id "com.apple.Notes"
		tell item 1 of (folders whose id is theFolderID as list)
			set theIDs to id of notes
			set theName to name
			return {|notes|:theIDs, |name|:theName}
		end tell
	end tell
end getNameAndNotes

on getNoteProperties(theNoteID, theFolderID)
	local theTitle, theHTML, theCreationDate, theModificationDate, theID
	tell application id "com.apple.Notes"
		tell (note 1 of (item 1 of (folders whose id is theFolderID as list)) whose id is theNoteID)
			set theTitle to name
			set theHTML to body
			set theCreationDate to creation date
			set theModificationDate to modification date
			set theID to id
			return {title:theTitle, creation:theCreationDate, modification:theModificationDate, |UUID|:theID, |HTML|:theHTML}
		end tell
	end tell
end getNoteProperties

on getNoteAttachments(theNoteID, theFolderID)
	local theAttachment, theName, theFiles
	tell application id "com.apple.Notes"
		set theFiles to {}
		tell (note 1 of (item 1 of (folders whose id is theFolderID as list)) whose id is theNoteID)
			repeat with theAttachment in attachments
				set theName to name of theAttachment
				if theName is not "" and theName is not missing value then
					set theFiles to theFiles & theName
					-- Still broken on High Sierra
					-- set theHFSPath to ((POSIX file thePath) as string)
					-- set theFile to theHFSPath & ":" & theName
					-- save theAttachment in file (theFile)
				end if
			end repeat
		end tell
		return theFiles
	end tell
end getNoteAttachments
